/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.inventories.BaseInternalInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.MEStorage;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.AEBaseInvBlockEntity;
import appeng.blockentity.misc.CondenserMEStorage;
import appeng.core.definitions.AEItems;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.AEItemFilters;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class CondenserBlockEntity
extends AEBaseInvBlockEntity
implements IConfigurableObject {
    public static final int BYTE_MULTIPLIER = 8;
    private final ConfigManager cm = new ConfigManager(() -> {
        this.saveChanges();
        this.addPower(0.0);
    });
    private final AppEngInternalInventory outputSlot = new AppEngInternalInventory(this, 1);
    private final AppEngInternalInventory storageSlot = new AppEngInternalInventory(this, 1);
    private final InternalInventory inputSlot = new CondenseItemHandler();
    private final Storage<FluidVariant> fluidHandler = new CondenseStorage(1.0 / (double)AEKeyType.fluids().getAmountPerOperation(), 81000L);
    private final CondenserMEStorage meStorage = new CondenserMEStorage(this);
    private final InternalInventory externalInv = new CombinedInternalInventory(this.inputSlot, new FilteredInternalInventory(this.outputSlot, AEItemFilters.EXTRACT_ONLY));
    private final InternalInventory combinedInv = new CombinedInternalInventory(this.inputSlot, this.outputSlot, this.storageSlot);
    private double storedPower = 0.0;

    public CondenserBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.cm.registerSetting(Settings.CONDENSER_OUTPUT, CondenserOutput.TRASH);
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.cm.writeToNBT(data);
        data.method_10549("storedPower", this.getStoredPower());
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.cm.readFromNBT(data);
        this.setStoredPower(data.method_10574("storedPower"));
    }

    public double getStorage() {
        IStorageComponent sc;
        class_1792 class_17922;
        class_1799 is = this.storageSlot.getStackInSlot(0);
        if (!is.method_7960() && (class_17922 = is.method_7909()) instanceof IStorageComponent && (sc = (IStorageComponent)class_17922).isStorageComponent(is)) {
            return sc.getBytes(is) * 8;
        }
        return 0.0;
    }

    public void addPower(double rawPower) {
        this.setStoredPower(this.getStoredPower() + rawPower);
        this.setStoredPower(Math.max(0.0, Math.min(this.getStorage(), this.getStoredPower())));
        this.fillOutput();
    }

    private void fillOutput() {
        double requiredPower = this.getRequiredPower();
        while (requiredPower <= this.getStoredPower() && !this.getOutput().method_7960() && requiredPower > 0.0 && this.canAddOutput()) {
            this.setStoredPower(this.getStoredPower() - requiredPower);
            this.addOutput();
        }
    }

    boolean canAddOutput() {
        return this.outputSlot.insertItem(0, this.getOutput(), true).method_7960();
    }

    private void addOutput() {
        this.outputSlot.insertItem(0, this.getOutput(), false);
    }

    InternalInventory getOutputSlot() {
        return this.outputSlot;
    }

    private class_1799 getOutput() {
        return switch (this.cm.getSetting(Settings.CONDENSER_OUTPUT)) {
            case CondenserOutput.MATTER_BALLS -> AEItems.MATTER_BALL.stack();
            case CondenserOutput.SINGULARITY -> AEItems.SINGULARITY.stack();
            default -> class_1799.field_8037;
        };
    }

    public double getRequiredPower() {
        return this.cm.getSetting(Settings.CONDENSER_OUTPUT).requiredPower;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.combinedInv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.outputSlot) {
            this.fillOutput();
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public double getStoredPower() {
        return this.storedPower;
    }

    private void setStoredPower(double storedPower) {
        this.storedPower = storedPower;
        this.method_5431();
    }

    public InternalInventory getExternalInv() {
        return this.externalInv;
    }

    public Storage<FluidVariant> getFluidHandler() {
        return this.fluidHandler;
    }

    public MEStorage getMEStorage() {
        return this.meStorage;
    }

    private class CondenseItemHandler
    extends BaseInternalInventory {
        private CondenseItemHandler() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public class_1799 getStackInSlot(int slot) {
            return class_1799.field_8037;
        }

        @Override
        public boolean isItemValid(int slot, class_1799 stack) {
            return CondenserBlockEntity.this.canAddOutput();
        }

        @Override
        public void setItemDirect(int slotIndex, class_1799 stack) {
            if (!stack.method_7960()) {
                CondenserBlockEntity.this.addPower(stack.method_7947());
            }
        }

        @Override
        public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
            if (!CondenserBlockEntity.this.canAddOutput()) {
                return stack;
            }
            if (!simulate && !stack.method_7960()) {
                CondenserBlockEntity.this.addPower(stack.method_7947());
            }
            return class_1799.field_8037;
        }

        @Override
        public class_1799 extractItem(int slot, int amount, boolean simulate) {
            return class_1799.field_8037;
        }

        @Override
        protected Storage<ItemVariant> createStorage() {
            return new CondenseStorage(1.0, Long.MAX_VALUE);
        }
    }

    private class CondenseStorage<T>
    extends SnapshotParticipant<Double>
    implements InsertionOnlyStorage<T> {
        private double pendingEnergy = 0.0;
        private final double energyFactor;
        private final long maxAmountPerOperation;

        public CondenseStorage(double energyFactor, long maxAmountPerOperation) {
            this.energyFactor = energyFactor;
            this.maxAmountPerOperation = maxAmountPerOperation;
        }

        public long insert(T resource, long maxAmount, TransactionContext transaction) {
            long amount = Math.min(this.maxAmountPerOperation, maxAmount);
            this.updateSnapshots(transaction);
            this.pendingEnergy += (double)amount * this.energyFactor;
            return amount;
        }

        protected Double createSnapshot() {
            return this.pendingEnergy;
        }

        protected void readSnapshot(Double snapshot) {
            this.pendingEnergy = snapshot;
        }

        protected void onFinalCommit() {
            CondenserBlockEntity.this.addPower(this.pendingEnergy);
            this.pendingEnergy = 0.0;
        }
    }
}

